<?php
// app/partials/bottom_nav.php
$navTree = load_nav_tree();
$navItems = build_bottom_nav($navTree, $activeKey ?? '');
?>
<nav class="bottom-nav">
  <?php foreach ($navItems as $it): ?>
    <?php
      $isActive = ($activeKey ?? '') === ($it['key'] ?? '');
      $icon = $it['icon'] ?: 'bi-circle';
      $title = $it['title'] ?? '';
      $type = $it['type'] ?? 'link';
    ?>
    <?php if ($type === 'dropdown'): ?>
      <div class="bn-item dropdown <?= $isActive ? 'active' : '' ?>">
        <a class="bn-link dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false">
          <span class="bn-ico"><i class="bi <?= htmlspecialchars($icon) ?>"></i></span>
          <span class="bn-txt"><?= htmlspecialchars($title) ?></span>
        </a>
        <ul class="dropdown-menu dropdown-menu-end">
          <?php foreach (($it['children'] ?? []) as $ch): ?>
            <?php if (($ch['type'] ?? 'link') === 'dropdown'): ?>
              <li><h6 class="dropdown-header"><?= htmlspecialchars($ch['title'] ?? '') ?></h6></li>
              <?php foreach (($ch['children'] ?? []) as $sub): ?>
                <li><a class="dropdown-item" href="<?= htmlspecialchars($sub['url'] ?? '#') ?>">
                  <?php if (!empty($sub['icon'])): ?><i class="bi <?= htmlspecialchars($sub['icon']) ?> me-2"></i><?php endif; ?>
                  <?= htmlspecialchars($sub['title'] ?? '') ?>
                </a></li>
              <?php endforeach; ?>
              <li><hr class="dropdown-divider"></li>
            <?php else: ?>
              <li><a class="dropdown-item" href="<?= htmlspecialchars($ch['url'] ?? '#') ?>">
                <?php if (!empty($ch['icon'])): ?><i class="bi <?= htmlspecialchars($ch['icon']) ?> me-2"></i><?php endif; ?>
                <?= htmlspecialchars($ch['title'] ?? '') ?>
              </a></li>
            <?php endif; ?>
          <?php endforeach; ?>
        </ul>
      </div>
    <?php else: ?>
      <a class="bn-item <?= $isActive ? 'active' : '' ?>" href="<?= htmlspecialchars($it['url'] ?? '#') ?>">
        <span class="bn-ico"><i class="bi <?= htmlspecialchars($icon) ?>"></i></span>
        <span class="bn-txt"><?= htmlspecialchars($title) ?></span>
      </a>
    <?php endif; ?>
  <?php endforeach; ?>
</nav>

