function toast(msg, type="primary"){
  const container = document.querySelector('.toast-container') || (()=> {
    const div = document.createElement('div');
    div.className = 'toast-container';
    document.body.appendChild(div);
    return div;
  })();

  const el = document.createElement('div');
  el.className = `toast align-items-center text-bg-${type} border-0 show mb-2`;
  el.setAttribute('role','alert');
  el.innerHTML = `
    <div class="d-flex">
      <div class="toast-body">${msg}</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" aria-label="Close"></button>
    </div>`;
  el.querySelector('button').addEventListener('click', ()=> el.remove());
  container.appendChild(el);
  setTimeout(()=> { if(el.isConnected) el.remove(); }, 3500);
}

async function postJSON(url, data){
  const res = await fetch(url, {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify(data)
  });
  const json = await res.json().catch(()=>({ok:false,msg:'Invalid JSON response'}));
  if(!res.ok && json.ok !== true){
    throw new Error(json.msg || ('HTTP '+res.status));
  }
  return json;
}
